
/*
 * $Header: /home/kline/devel/atom/RCS/utils.c,v 1.1 1996/09/04 04:56:19 kline Exp kline $
 * misc atom utilities.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "msg.h"
#include "atom.h"

#ifdef NOTUSED
char tempfname[512];*//* ``TEMP<pid>'' /* file when squeezing excess newlines */
#endif

/*
 * memory and misc utility functions
 */


/***
 ***
		for bcopy() and memmove()
 ***
 ***/


/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


void
bcopy(const void *src0, register void *dst0, register size_t length)
{
   register char *dst = dst0;
   register const char *src = src0;
   register size_t t;

   if (length == 0 || dst == src)      /* nothing to do */
      goto done;

   /*
       * Macros: loop-t-times; and loop-t-times, t>0
       */
#define   TLOOP(s) if (t) TLOOP1(s)
#define   TLOOP1(s) do { s; } while (--t)

   if ((unsigned long)dst < (unsigned long)src) {
      /*
       * Copy forward.
       */
      t = (int)src;   /* only need low bits */
      if ((t | (int)dst) & wmask) {
         /*
          * Try to align operands.  This cannot be done
          * unless the low bits match.
          */
         if ((t ^ (int)dst) & wmask || length < wsize)
            t = length;
            else
            t = wsize - (t & wmask);
         length -= t;
         TLOOP1(*dst++ = *src++);
      }
      /*
       * Copy whole words, then mop up any trailing bytes.
       */
      t = length / wsize;
      TLOOP(*(word *)dst = *(word *)src; src += wsize; dst += wsize);
      t = length & wmask;
      TLOOP(*dst++ = *src++);
   } else {
            /*
             * Copy backwards.  Otherwise essentially the same.
             * Alignment works as before, except that it takes
             * (t&wmask) bytes to align, not wsize-(t&wmask).
             */
      src += length;
      dst += length;
      t = (int)src;
      if ((t | (int)dst) & wmask) {
         if ((t ^ (int)dst) & wmask || length <= wsize)
            t = length;
            else
            t &= wmask;
         length -= t;
         TLOOP1(*--dst = *--src);
      }
      t = length / wsize;
      TLOOP(src -= wsize; dst -= wsize; *(word *)dst = *(word *)src);
      t = length & wmask;
      TLOOP(*--dst = *--src);
   }
done:
   return;
}

 void *
memmove(register void *dst0, const void *src0, register size_t length)
{
   register char *dst = dst0;
   register const char *src = src0;
   register size_t t;

   if (length == 0 || dst == src)      /* nothing to do */
      goto done;

   /*
       * Macros: loop-t-times; and loop-t-times, t>0
       */
#define   TLOOP(s) if (t) TLOOP1(s)
#define   TLOOP1(s) do { s; } while (--t)

   if ((unsigned long)dst < (unsigned long)src) {
      /*
             * Copy forward.
             */
      t = (int)src;   /* only need low bits */
      if ((t | (int)dst) & wmask) {
         /*
                   * Try to align operands.  This cannot be done
                   * unless the low bits match.
                   */
         if ((t ^ (int)dst) & wmask || length < wsize)
            t = length;
            else
            t = wsize - (t & wmask);
         length -= t;
         TLOOP1(*dst++ = *src++);
      }
      /*
             * Copy whole words, then mop up any trailing bytes.
             */
      t = length / wsize;
      TLOOP(*(word *)dst = *(word *)src; src += wsize; dst += wsize);
      t = length & wmask;
      TLOOP(*dst++ = *src++);
   } else {
      /*
             * Copy backwards.  Otherwise essentially the same.
             * Alignment works as before, except that it takes
             * (t&wmask) bytes to align, not wsize-(t&wmask).
             */
      src += length;
      dst += length;
      t = (int)src;
      if ((t | (int)dst) & wmask) {
         if ((t ^ (int)dst) & wmask || length <= wsize)
            t = length;
            else
            t &= wmask;
         length -= t;
         TLOOP1(*--dst = *--src);
      }
      t = length / wsize;
      TLOOP(src -= wsize; dst -= wsize; *(word *)dst = *(word *)src);
      t = length & wmask;
      TLOOP(*--dst = *--src);
   }
done:
   return (dst0);
}


/*
 * strsub.c -- substitute first occurence of pattern with another string
 *
 *   Author: Lars Wirzenius, licensed by GPL
 */

char *
strsub(register char *str, const char *pat, const char *sub)
{
   size_t lenpat, lensub, lenstr;
   char *strstr();

   str = strstr(str, pat);
   if (str == NULL)
      return NULL;

   lenstr = strlen(str);
   lenpat = strlen(pat);
   lensub = strlen(sub);

   /* make room for substituted string, or remove slack after it */
   if (lensub != lenpat)
      (void)memmove(str + lensub, str + lenpat, lenstr + 1 - lenpat);

   (void)memcpy(str, sub, lensub);
   return str + lensub;
}

/*
 * InsertSubstring (subgstr())
 *  -- insert all occurences of pattern with another string
 *
 *   Author: Lars Wirzenius, licensed by GPL
 */


int
InsertSubstring(register char *str, const char *pat, const char *sub,size_t max)
{
   size_t lenpat, lensub;
   const char *p;
   register short unsigned int n;
   char *strstr();

   /*
    * Check that the all substitutions will fit.
    */
   lenpat = strlen(pat);
   lensub = strlen(sub);
   if (lenpat < lensub) {
      for (n = 0, p = str; (p = strstr(p, pat)) != NULL; p += lenpat)
         ++n;
      if (strlen(str)+1 + n*(lensub-lenpat) > max)
         return -1;
   }

   /*
            * Substitute.
            */
   for (n = 0; (str = strsub(str, pat, sub)) != NULL; ++n)
      continue;
   return (int)n;
}


/*
 * leave
 * Clean up atom and exit.
 */
void    
leave (register int exit_val) 
{
        exit (exit_val);
}

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>


#define rid_nl() while(getchar() != '\n');

int
callyn()
{
	int default_yn(char *,  char ), yn;

	yn = default_yn("Are you happy? [yn]", 'y');
	printf("DEBUG (%d) returned\n", yn);
	return yn;
}

int
default_yn(char *question,  char ch)
{
 register int reply, done = 0, retval;

 if (isupper(ch)) ch = tolower(ch);
 while (!done)
 {
  switch (ch)
  {
        case 'n':
                fprintf(stdout, "no  %s [n]  ", question);
                break;
        case 'y':
                fprintf(stdout, "yes %s [y]  ", question);
                break;
        default :
                fprintf(stderr, "Shouldn't happen --{%c}--\n", ch);
                fprintf(stderr, "The error is within the second argument that calls\
			  this function, %s.\n", __FUNCTION__);
                exit (1);

  }
   reply = getchar();
   if (isupper(reply)) reply = tolower(reply);
  if (reply == 'y')
  {
   done = 1, retval = 1; rid_nl();
  }
  else if (reply == 'n')
  {
   done = 1, retval = 0; rid_nl();
  }
  else if (reply == '\n')
  {
          switch (ch)
          {
                case 'n':
                        done = 1; retval = 0; break;
                case 'y':
                        done = 1; retval = 1; break;
                default :
                        exit(fprintf(stderr, "Can't happen --{%c}--\n", ch));
          }
  }
 }
 return (retval);
}

