
/* 
 * spacings.c
 * $Header: /home/kline/devel/atom/RCS/spacing.c,v 1.4 1996/09/05 04:04:16 kline Exp kline $
 */

#include <stdio.h>
#include "msg.h"
#include "atom.h"

void
Do_Physical_space(char *buf, int html, int latex, FILE *fp)
{

	static int psbreak_count = 0;

	if (*buf == '\n' && psbreak_count < 5)
	{ 
	/*printf("PSPACE: DEBUG: psbreak_count = (%d)\n", psbreak_count);*/
		psbreak_count++;
	}  
	else if (*buf != '\n')
	{
		psbreak_count = 0;
	}
	if (psbreak_count == 5)
	{
		if (lookahead (fp))
		{
			puts("printing Do_Break");
			if (html)
			{
				fprintf(fp, HSPACE);
			}
			else if (latex)
			{
				fprintf(fp, TSPACE);
			}
			psbreak_count = 0;
		}


	}
}
int
lookahead (FILE *fp)
{
        char  lookaheadc;               /* lookahead character  */
        short int rval = 0;

        if (lookaheadc = getc (fp))
        {
                if (lookaheadc != '\n') 
                {
                        rval = 1;
                }
                else
                {
                        rval = 0;
                }
        }
        ungetc(lookaheadc, fp);
        return rval;
}
void
put_break(int html, int latex, FILE *fp)
{
        if (html)
        {   
                fprintf(fp, HSPACE);
        }       
        else if (latex) 
        {       
                fprintf(fp, TSPACE); 
        }   
}
