/* msg.h - a simple replacement for fprintf for debug- and error-messages
 *  $Header: /home/kline/devel/atom/RCS/msg.h,v 1.1 1996/09/04 04:56:19 kline Exp kline $
 * Kjetil T. Homme, <kjetilho@ifi.uio.no>
 * University of Oslo, 1993. Public domain.
 */

#if !defined(MSG_H)
#define MSG_H

/* Classes of messages
 * The names are arbitrary, but the last must be MSG_CATEGORIES.
 */

/*
typedef enum {
    khtrace, khdebug, khwarning, kherror, khfatal, MSG_CATEGORIES
} msg_category_t;
*/


#define khmsg MSG
typedef enum {
    TRACE, DEBUG, WARNING, ERROR, FATAL, MSG_CATEGORIES
} msg_category_t;

typedef int msg_severity_t;
#define MSG_MAX_SEVERITY   10

/* Define MSG_PARSE_ENVIR if you want parsing of the environment
 * variable MSG_LEVEL
 */
#define MSG_PARSE_ENVIR

/* Define MSG_COUNT_CALLS if you want to trap when a number of calls of
 * msg() have been executed (specified in msg_warnings[]).
 */
#define MSG_COUNT_CALLS

#if defined(MSG_COUNT_CALLS)
   /* Execute this when the limit on warnings has been reached
    */
#  define MSG_EXIT(class) exit(1)
#  include <stdlib.h> /* for the prototype of exit */
#endif

/* ______ No need to change anything below ______ */

#if defined(MSG_PARSE_ENVIR)
#    define MSG_CONST
#else
#    define MSG_CONST const
#endif

extern MSG_CONST msg_severity_t msg_level[MSG_CATEGORIES];
extern msg_category_t msg_category;	/* used for communication */
extern msg_severity_t msg_severity;	/* used for communication */

#if defined(MSG_COUNT_CALLS)
extern int msg_warnings[MSG_CATEGORIES];
#define MSG(category, severity, args) \
    do { \
        if (severity >= msg_level[category]) { \
	    msg_category = category; \
	    msg_severity = severity; \
            msg_printf args; \
            if (msg_warnings[category] && --msg_warnings[category] == 0) { \
                MSG_EXIT(category); \
	    } \
        } \
    } while (0);
#else
#define MSG(category, severity, args) \
    do { \
        if (severity >= msg_level[category]) { \
	    msg_category = category; \
	    msg_severity = severity; \
            msg_printf args; \
        } \
    } while (0);
#endif

void msg_init(void);
void msg_printf(const char *fmt, ...);

#endif /* MSG_H */
