/* 
 * center,c
 * $Header: /home/kline/devel/atom/RCS/center.c,v 2.7 1998/10/17 20:09:00 kline Exp kline $
 */

#include <stdio.h>
#include "msg.h"
#include "atom.h"

int err_tab = 0;

void
DoCenterOutput(char *buf, FILE *fp, int html, int latex)
{
	/*
	 * the formatting below ends in "\n\n" in the event that
	 * paragraphing isn't otherwise denoted:: better safe than not.
	 */
	if (html)
	{
		fprintf(fp, "%s\n%s\n%s\n\n", BEGIN_CENTER_TAG,
		  buf, END_CENTER_TAG);
	}
	else if (latex)
	{
		fprintf(fp, "\\begin{center}\n%s\n\\end{center}\n\n", buf);
	}
}

/*
 * if a string is ASCII-centered, there are nothing but blank
 * spaces to the left of the string.  This function returns the
 * number of spaces.
 */
unsigned int
NumberOfLeadingSpaces(char *s)
{
	unsigned int scount = 0;
	while (*s)
	{
		if (*s == ' ')
		{
			scount++;
		}
		if (!(*s == ' '))
			break;
		s++;
	}
	return (scount);
}


/*
 * Return the length of the string in the middle.
 */

unsigned int
CenterStringLength(char *s)
{
	unsigned int cscount = 0;
	while (*s)
	{
		if (isprint(*s) )
		{
			cscount++;
		}
		if (*s == '\t')
		{
			err_tab = 1;
			break;
		}
		if (*s == '\n')
		{
			break;
		}
		s++;
	}
	return cscount;
}


/* 
 * formula for determining whether centerstring is really centered.
 *
 *  (note that we can be off-by-one byte: the centerstring may have an
 *   odd number of characters)
 *
 * if (80/2) - (centerlength/2) == nleadingspaces ||
 * if (80/2) - (centerlength/2)-1 == nleadingspaces.
 *
 * [[[ do we want to allow other-side offcentering? ]]]
 *
 * boolean::
 * if either of the above is true, then string marked CENTERED.
 */

int
DetermineCenteredness(unsigned int lspaces, int length)
{
   MSG(TRACE, 3, ("determing eq = (%d), spaces = (%d)\n", 
	( (80/2) - ((length)/2)-1), lspaces ));
   MSG(TRACE, 3, ("determing eq = (%d), spaces = (%d)\n", 
	( (80/2) - ((length)/2)), lspaces ));

	if ( ( (80/2) - ((length)/2)) == lspaces  ||
	   ( (80/2) - ((length)/2)-1) == lspaces )
	{
	   return 1;
	}
	else
	   return 0;
}
int 
GutenbergCentered(unsigned int spaces)
{
	if (spaces >= 15 )
		return 1;
	else 
		return 0;
}
#include <stdio.h>
#include <string.h>

/*
 * seriously needs to be rewritten with structure rather than
 * arrays[].

 * struct gutenberg
 * {
 *   struct gutenberg *last;
 *   char buffer[4096];
 *   short int end_punct;
 * };
 *
 * or the like.  
 */

#ifdef GDEVEL
char tmpspace[512];
DoGutenberg(char s1[], FILE *fp_out, int *to_paragraph, int html, int latex,
            int quote_only, int italics_only )
{
#define DELIM " \""

        int i = 0, k;
	/*char *bp, buf[512], *delim = " \"`", *emphasize, obuf[1024], *tok;
	 */
	char *bp, buf[512], *delim = DELIM, *emphasize, obuf[1024], *tok;
	unsigned char tokarray[128];
	char *mystrtok(), *re_uppercase(),*uppercase_first();
	char *rup;


	clear (tokarray, 128); /* 0-fill token array */
	bp = strcpy(buf, tmpspace);  /* this works:: bp  */
	strcpy(bp, s1); /* bp filled with writable mem works like this, too */
	while ((tok = mystrtok(bp, delim, stdout)) != NULL)
	{
		i++;
		tokarray[i] = screen_for_period(tok);
		bp = NULL; 
		if (isupper(*tok))
		{
			if (is_all_caps(tok))
			{
				emphasize = change_case(tok, LOWER);
				if ( CAPITALIZATION(i) )
				{
				   emphasize = uppercase_first(emphasize);
				   }
				   {
				   /*
				    * note that it is virtually impossible
				    * to re-capitalize all lower-cased 
				    * strings.  Proper nouns, i.e.,
				    * cannot readily be caught.
				    */

				   if (!strcmp(emphasize, "i"))
				   {
				     sprintf(obuf, " <EM>I</EM> ");
				   }
				   else
				   {
				     sprintf(obuf, " <EM>%s</EM> ", emphasize);
				   }
				}
				fprintf(fp_out, "%s", obuf);
			}
			else
			{
				fprintf(fp_out, " %s", tok);
			}
		}
		else
			fprintf(fp_out, " %s", tok);
	}

        /* do paragraphing */
               if (*to_paragraph == 1)
               {
                  *to_paragraph = 0;
                  if (quote_only == 0 && italics_only == 0)
                  {
                     if (html)
                     {
                        /* Paragraph TAG for hypertex markup */
                        (void)fprintf(fp_out, "\n<P>\n");
                     }
                     else if (latex)
                     {
                        /* In LaTeX paragraphs are denoted by newline breaks */
                        (void)fprintf(fp_out, "\n");
                     }
                  }

		}
}
#endif /* GDEVEL **/


is_all_caps(char *s)
{
	int allcaps = 1;  /* assume yes */
	if (islower(*s)) return 0;          /* should Never be ... */

	while (*s) /* starting with at least one CAP */
	{
		if (islower(*s))
		{
			allcaps = 0;
			break;
		}
		s++;
	}
	return allcaps;
}


char *
change_case(register char *s, register short int state)
{
	static char p[128];
	register short int i = 0;
	clear (p, 128);
	while (*s)
	{
		if (state == UPPER)
			islower(*s) ? (p[i] = toupper(*s)) : (p[i] = *s);
		else
			isupper(*s) ? (p[i] = tolower(*s)) : (p[i] = *s);
		s++, i++;
	}
	return (p);
}
screen_for_period(char *s)
{
	int period = 0;
	while (*s)
	{
		if (*s == '.' || *s == '?')
			period = END_PUNCTUATION;
		s++;
	}
	return period;
}

/*
 * Uppercase first byte of unwritable char array
 */
char *
uppercase_first(char *s)
{
	static char capfirst[256]; 
	short int i = 0;

	clear (capfirst, 256);
	capfirst[i++] = toupper(*s++); 
	while (*s)
	{
		capfirst[i++] = *s++;
	}
	capfirst[i] = '\0';
	return capfirst;
}
#include <stddef.h>
#include <string.h>

char *
mystrtok(register char *s, register const char *delim, FILE *fp)
{
	register char *spanp;
	register int c, sc;
	char *tok;
	static char *last;


	if (s == NULL && (s = last) == NULL)
		return (NULL);

	/*
	 * Skip (span) leading delimiters (s += strspn(s, delim), sort of).
	 */
cont:
	c = *s++;
	for (spanp = (char *)delim; (sc = *spanp++) != 0;) {
		fprintf(fp, " ");
		if (c == sc)
			goto cont;
	}

	if (c == 0) {		/* no non-delimiter characters */
		last = NULL;
		return (NULL);
	}
	tok = s - 1;

	/*
	 * Scan token (scan for delimiters: s += strcspn(s, delim), sort of).
	 * Note that delim must have one NUL; we stop if we see that, too.
	 */
	for (;;) {
		c = *s++;
		spanp = (char *)delim;
		do {
			if ((sc = *spanp++) == c) {
				if (c == 0)
					s = NULL;
				else
					s[-1] = 0;
				last = s;
				return (tok);
			}
		} while (sc != 0);
	}
	/* NOTREACHED */
}

static int
match(argument, pattern)
register char *argument, *pattern;
{
        register short int length = strlen(pattern), ret_val = 0;
        while (strlen(argument) >= length)
        {
                if (!strncmp(argument++, pattern, length))
                        ret_val = 1;
        }
        return (ret_val);
}

char *
re_uppercase(char *s)
{
	if (!strcmp(s, "i"))
		return ("I");
}
