/*
 * header for atom.c
 * $Header: /home/kline/devel/atom/RCS/atom.h,v 2.27 2009/05/26 19:20:04 kline Exp kline $
 */

/*
		 NOTE:

		 If you would rather have the italics delimiter
		 be an underscore, make that change below
*/


#define clear(s, n) {register int __Z;for(__Z=0;__Z<n;__Z++)s[__Z]='\0';}
/* this probably insures either true/false or compiler will gripe */
typedef enum _bool { false = 0, true = 1 } boolean;

#define even(n) ((n%2)==0)
#define odd(n) ((n%2)!=0)
#define EVEN 4
#define ODD  11
#define SLUSH 128
/*
 *  these symbols can easily be changed for differing char sets.
 */

#define BBEGIN1 "<BLOCKQUOTE>\n"
#define BEND1 "</BLOCKQUOTE>\n"

#define BBEGIN2 "<BLOCKQUOTE>\n<BLOCKQUOTE>\n"
#define BEND2 "</BLOCKQUOTE>\n</BLOCKQUOTE>\n"

#define BBEGIN3 "<BLOCKQUOTE>\n<BLOCKQUOTE>\n<BLOCKQUOTE>\n"
#define BEND3 "</BLOCKQUOTE>\n</BLOCKQUOTE>\n</BLOCKQUOTE>\n"

#define BBEGIN4 "<BLOCKQUOTE>\n<BLOCKQUOTE>\n<BLOCKQUOTE>\n<BLOCKQUOTE>\n"
#define BEND4 "</BLOCKQUOTE>\n</BLOCKQUOTE>\n</BLOCKQUOTE>\n</BLOCKQUOTE>\n"

#define BBEGIN5 "<BLOCKQUOTE>\n<BLOCKQUOTE>\n<BLOCKQUOTE>\n<BLOCKQUOTE>\n<BLOCKQUOTE>\n"
#define BEND5 "</BLOCKQUOTE>\n</BLOCKQUOTE>\n</BLOCKQUOTE>\n</BLOCKQUOTE>\n</BLOCKQUOTE>\n"


#define BSLASH '\\'
#define BEGIN_CENTER_TAG "<CENTER>"
#define END_CENTER_TAG   "</CENTER>"
#define DQUOTE '"'	   /* standard typewriter-style double quote       */
#define ELIPSE "..."
#define ERROR 2
#define FATAL 1
#define LDOTS "{\\ldots}"
#define LOWER 0
#define HBEGIN "  <HEAD>\n    <TITLE>  <!your title here -->  </TITLE>\n    <! your header lines here -->\n  </HEAD>\n\n<META NAME=\"Keywords\" CONTENT=\"whatever\">\n <META NAME=\"revisit-after\" CONTENT=\"7 days\">\n <META NAME=\"author\" content=\"Gary Kline\">\n <META NAME=\"copyright\" content=\" Thought Unlimited\">\n<BODY BGCOLOR=\"#FFFFFF\" LINK=\"#00FFFF\" VLINK=\"#006633\"><FONT SIZE=\"4\">\n"
#define HEND   "\n</FONT>\n</BODY>"  /*goes just before </HTML>  */
#define HHEADER "<!DOCTYPE html PUBLIC '-//IETF//DTD HTML//EN'>\n\
<!-autotranslation from ASCII or ISO-8859.1 by Gary Kline, kline@thought.org--->\n"
#define HSPACE "<BR>\n<BR>\n<BR>\n<BR>\n<BR>\n"
#define H_TABEQUALS(b) (b[0]=='\t'&&b[1]=='='&&b[2]=='\n') /* private markup */
/***#define HPARA "&nbsp&nbsp&nbsp&nbsp&nbsp" ***/

#define HPARA "abcdefg"
#define HTAIL "\n</HTML>\n"
#define L_DQ "&ldquo;"  
/*#define I_DELIM '/'*/   /*  underscore italics delimiter, as in /this/   */
/*#define I_DELIM '_'*/   /*  underscore italics delimiter, as in _this_   */
#define I_DELIM '*'       /*  italics delimiter, as in *shoot!*            */
#define NO_ERRS 0
#define ONE_NEWLINE 1     /* one newline between paragraphs is the default */
#define END_PUNCTUATION 1
#define CAPITALIZATION(i) (tokarray[i-1] == END_PUNCTUATION)
#define R_DQ "&rdquo;"
#define TATTRIBUTE " autotranslation from ASCII or ISO-8859.1 by Gary Kline, kline@thought.org\n\n"
#define TCOMMENT "%%%"
#define THEADER "%%% file"
//#define TBEGIN "  <TITLE>\n<! your Web Title here -->\n  </TITLE>\n\n"
#define TSPACE "\\vspace*{.5in}"
#define TTAIL   "\n\n%%% end %%%\n"
#define SLASH '/'
#define SQUEEZE_PHYSICAL_ERR "squeeze and physical-space options are mutually exclusive\n"
#define UPPER 1


typedef   int word;      /* "word" used for optimal copy speed */
#define   wsize   sizeof(word)
#define   wmask   (wsize - 1)

static int get_nquotes(char *s);
static int get_nsymbols(char *s, char);
int InsertSubstring(char *, const char *, const char *, size_t);
char *strsub(char *, const char *, const char *);
static void report_isym_err(short, char *, int, char *);
void *memmove(void *, const void *, size_t);
void bcopy(const void *, void *, size_t);
static int BeginningQuote (char *s);
static int IsNewParagraph(char *buf);
static int length_to_symbol(char *s, char symbol);
static char *left ( char *, unsigned int);
static void usage (char *);
void Do_Physical_space(char *, int, int, FILE *);
void put_break(int, int, FILE *);
static int IsEmbeddedTab(char *);
static int LeadingSpaces(char *, int);
static int qfilter(int, char **, char *);
char *StepPast(char *, unsigned int );
static char *strsave(const char *);
void ProcessText(FILE *, char *, char *, int, char *);
static char *ProcessItalicizedSymbols(char *);
static char *scan_buf_0 (char *);
char *scan_buf_1 (char *);
int Squeeze(char *);
unsigned int NumberOfLeadingSpaces(char *);
unsigned int CenterStringLength(char *);
int DetermineCenteredness(unsigned int, int);
void DoCenterOutput(char *, FILE *, int, int);
int OpenForCentering(char *, int, int);
static int match(char *, char *);
char *change_case(char *, short int);

/*
 * avoid local env hassles:
 */
#ifdef WWW
#define _A      0x00000100L             /* Alpha */
#endif








/*
 * extern variables
 */
/*extern char tempfname[];*/   /* ``TEMP<pid>'' file */
extern int err_tab;        /* relate that there was a TAB in centered string */
